/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package Chapter11.map.solution;

import Chapter11.map.*;
import java.time.*;
import java.util.Map;

/**
 * @author Matthew Gregory
 */
public class StartHere {

    public static void main(String[] args) {
        DataSource myInstances = new DataSource();

        //fetch my variables
        Meeting initialMeeting = myInstances.meetings.get("initialMeeting");
        Meeting internalMeeting = myInstances.meetings.get("internalMeeting");
        Meeting followupMeeting = myInstances.meetings.get("followupMeeting");
        //fetch "Matthew Gregory" (remember we used full name as the key)
        Person me = myInstances.people.get("Matthew Gregory");
        //fetch my schedule
        //We haven't defined this as a class so we need to declare it explicitly as a Map
        Map<LocalDate,Meeting> mySchedule = myInstances.mySchedule;

        //Print out me
        System.out.println("Details of me: ");
        me.printDetails();
        System.out.println();
        
        //Print out a meeting
        System.out.println("Details of follow up meeting: ");
        followupMeeting.displayMeetingDetails();
        System.out.println();
        
        //Print my Schedule
        System.out.println("Details of the complete schedule: ");
        System.out.println("Schedule: " + mySchedule);
        System.out.println();
    }
}
